/****************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Quick 3D.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
****************************************************************************/

import QtQuick 2.15
import HelperWidgets 2.0
import QtQuick.Layouts 1.12

Section {
    caption: qsTr("Frustum Camera")

    SectionLayout {
        Label {
            text: qsTr("Top")
            tooltip: qsTr("Sets the top plane of the camera view frustum.")
        }
        SecondColumnLayout {
            SpinBox {
                maximumValue: 9999999
                minimumValue: -9999999
                realDragRange: 5000
                decimals: 0
                backendValue: backendValues.top
                Layout.fillWidth: true
            }
        }
        Label {
            text: qsTr("Bottom")
            tooltip: qsTr("Sets the bottom plane of the camera view frustum.")
        }
        SecondColumnLayout {
            SpinBox {
                maximumValue: 9999999
                minimumValue: -9999999
                realDragRange: 5000
                decimals: 0
                backendValue: backendValues.bottom
                Layout.fillWidth: true
            }
        }
        Label {
            text: qsTr("Right")
            tooltip: qsTr("Sets the right plane of the camera view frustum.")
        }
        SecondColumnLayout {
            SpinBox {
                maximumValue: 9999999
                minimumValue: -9999999
                realDragRange: 5000
                decimals: 0
                backendValue: backendValues.right
                Layout.fillWidth: true
            }
        }
        Label {
            text: qsTr("Left")
            tooltip: qsTr("Sets the left plane of the camera view frustum.")
        }
        SecondColumnLayout {
            SpinBox {
                maximumValue: 9999999
                minimumValue: -9999999
                realDragRange: 5000
                decimals: 0
                backendValue: backendValues.left
                Layout.fillWidth: true
            }
        }
    }
}
